/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames.events;

import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.JsonFunctions;
import com.natamus.villagernames.config.ConfigHandler;
import com.natamus.villagernames.util.Names;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VillagerEvent {
    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof VillagerEntity)) {
            boolean goname = false;
            if (((Boolean)ConfigHandler.GENERAL.nameModdedVillagers.get()).booleanValue() && EntityFunctions.isModdedVillager((Entity)entity)) {
                goname = true;
            }
            if (!goname) {
                return;
            }
        }
        if (!entity.func_145818_k_()) {
            EntityFunctions.nameEntity((Entity)entity, (String)Names.getRandomName());
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getTarget();
        if (!entity.getClass().equals(VillagerEntity.class)) {
            return;
        }
        if (!entity.func_145818_k_()) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if (player.func_213453_ef()) {
            return;
        }
        final VillagerEntity villager = (VillagerEntity)entity;
        VillagerData d = villager.func_213700_eh();
        String profession = d.func_221130_b().toString();
        if (profession == "none" || profession == "nitwit") {
            return;
        }
        if (profession.contains(":")) {
            profession = profession.split(":")[1];
        }
        if (profession.contains("-")) {
            profession = profession.split("-")[0].trim();
        }
        ITextComponent namecomponent = villager.func_200200_C_();
        String json = ITextComponent.Serializer.func_150696_a((ITextComponent)namecomponent);
        final HashMap map = JsonFunctions.JsonStringToHashMap((String)json);
        final String prevname = (String)map.get("text");
        final String upperprofession = profession.substring(0, 1).toUpperCase() + profession.substring(1);
        map.put("text", prevname + " the " + upperprofession);
        villager.func_200203_b((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)JsonFunctions.HashMapToJsonString((HashMap)map)));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                map.put("text", prevname.replace(" the ", "").replace(upperprofession, ""));
                villager.func_200203_b((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)JsonFunctions.HashMapToJsonString((HashMap)map)));
            }
        }).start();
    }
}

